/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.license;

import ibm.nways.jdm.license.LicenseStatus;
import ibm.nways.jdm.license.MessageDialogWithHelp;
import java.awt.Frame;
import java.util.Date;
import java.util.ResourceBundle;

public class LicenseStatusPopup {
    private static ResourceBundle myResources = null;
    private ResourceBundle resBundle;
    private LicenseStatus licStat;

    public LicenseStatusPopup(LicenseStatus licenseStatus, ResourceBundle resourceBundle) {
        Date date = new Date(0L);
        this.licStat = licenseStatus == null ? new LicenseStatus(4, "LUM.NMA.Suite") : (licenseStatus.getStatus() == 3 && date.equals(licenseStatus.getTimeOutDate()) ? new LicenseStatus(4, "LUM.NMA.Suite") : licenseStatus);
        this.resBundle = resourceBundle;
        if (myResources == null) {
            myResources = ResourceBundle.getBundle("ibm.nways.jdm.license.LicenseResourceBundle");
        }
    }

    public LicenseStatusPopup(LicenseStatus licenseStatus) {
        Date date = new Date(0L);
        this.licStat = licenseStatus == null ? new LicenseStatus(4, "LUM.NMA.Suite") : (licenseStatus.getStatus() == 3 && date.equals(licenseStatus.getTimeOutDate()) ? new LicenseStatus(4, "LUM.NMA.Suite") : licenseStatus);
        if (myResources == null) {
            myResources = ResourceBundle.getBundle("ibm.nways.jdm.license.LicenseResourceBundle");
        }
        this.resBundle = myResources;
    }

    public LicenseStatusPopup() {
        this.licStat = new LicenseStatus(4, "LUM.NMA.Suite");
        if (myResources == null) {
            myResources = ResourceBundle.getBundle("ibm.nways.jdm.license.LicenseResourceBundle");
        }
        this.resBundle = myResources;
    }

    public void printWarning(Frame frame) {
        if (this.licStat.printWarning()) {
            MessageDialogWithHelp messageDialogWithHelp = new MessageDialogWithHelp(frame, true);
            messageDialogWithHelp.setTitle(this.BuildTitleText());
            messageDialogWithHelp.init(this.BuildLicenseText());
            messageDialogWithHelp.show();
        }
    }

    private String BuildTitleText() {
        String string = this.licStat.getLicKey();
        if (myResources == null) {
            myResources = ResourceBundle.getBundle("ibm.nways.jdm.license.LicenseResourceBundle");
        }
        try {
            string = myResources.getString(String.valueOf(this.licStat.getLicKey()) + "-title");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String BuildLicenseText() {
        String string = this.licStat.getLicKey();
        if (myResources == null) {
            myResources = ResourceBundle.getBundle("ibm.nways.jdm.license.LicenseResourceBundle");
        }
        String string2 = null;
        string2 = this.licStat.getStatus() == 4 ? myResources.getString("NMA") : (this.licStat.getProductCode() == "LUM.NMA.Suite" || this.licStat.getProductCode() == "LUM.NMA.Trial" ? String.valueOf(myResources.getString("prod")) + myResources.getString(this.licStat.getProductNameKey()) : String.valueOf(myResources.getString("prod")) + this.resBundle.getString(this.licStat.getProductNameKey()));
        try {
            String string3 = null;
            switch (this.licStat.getStatus()) {
                case 4: {
                    string3 = new String(String.valueOf(string2) + "\n" + "\n" + myResources.getString(this.licStat.getLicKey()));
                    break;
                }
                case 2: 
                case 3: {
                    string3 = new String(String.valueOf(string2) + "\n" + "\n" + myResources.getString(String.valueOf(this.licStat.getLicKey()) + "-1") + this.licStat.getTimeOutDate() + "\n" + myResources.getString(String.valueOf(this.licStat.getLicKey()) + "-2") + "\n" + "\n" + myResources.getString("order"));
                    break;
                }
                case 1: {
                    string3 = new String(String.valueOf(string2) + "\n" + "\n" + myResources.getString(String.valueOf(this.licStat.getLicKey()) + "-1") + this.licStat.getCurrentNodes() + "\n" + myResources.getString(String.valueOf(this.licStat.getLicKey()) + "-2") + this.licStat.getLicensedNodes() + "\n" + "\n" + myResources.getString("order"));
                    break;
                }
            }
            string = string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

